// This MFC Samples source code demonstrates using MFC Microsoft Office Fluent User Interface 
// (the "Fluent UI") and is provided only as referential material to supplement the 
// Microsoft Foundation Classes Reference and related electronic documentation 
// included with the MFC C++ library software.  
// License terms to copy, use or distribute the Fluent UI are available separately.  
// To learn more about our Fluent UI licensing program, please visit 
// http://msdn.microsoft.com/officeui.
//
// Copyright (C) Microsoft Corporation
// All rights reserved.

// bbDemoDoc.h : interface of the CbbDemoDoc class
//

#pragma once

class AudioStream;
class DiskController;

class CbbDemoDoc : public CDocument
{
	friend class CbbDemoView;
protected: // create from serialization only
	CbbDemoDoc();
	DECLARE_DYNCREATE(CbbDemoDoc)

public: /* Members */
	enum IOMode { 
		IDLE, 
		FROMDEV, 
		TODISK, 
		FROMDISK 
	};

public: /* Methods */
	static UINT threadEntry(LPVOID param);
	void setStation(Channel c, float freq);
	void slideStation(short d);

private: /* Members */
	int deviceNum;
	bool deviceOpen;
	IOMode mode;
	CWinThread* procThread;
	bool programRunning;

	AudioStream* as;       
	
	DiskController* diskCtrl;
	CString fileName, dirName;

	float leftFreq, rightFreq;
	Channel lastChanged;

	int playbackDelay;
	DWORD playbackStart, playbackStop;
	bool playbackFirstTime;

	// Spectrum analysis variables
	Ipp32f* view;           // Results of FFT 
	int index;
	double realStart;

	Ipp32f* buf;            // Buffer returned from API
	Ipp32f* window;         // Blackman window
	Ipp32f* compBuf;        // Complex buffer
	Ipp16s* diskio;         // 16 bit shorts, to be stored to disk
	IppsFFTSpec_R_32f* fftSpec;

private: /* Methods */
	bool ConnectDevice(void);
	void DisconnectDevice(void);
	void ConfigureDevice(void);
	void StopDevice(void);

	void buildWindow(void);
	int processThread(void);
	void invalidateView(void);
	void spectrumAnalysis(void);
	void getFromDisk(void);
	void resetPlayback(void);

public: /* Overrides */
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

public: /* Implementation */
	virtual ~CbbDemoDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

protected: /* Message Map */
	DECLARE_MESSAGE_MAP()
public:
	virtual void OnCloseDocument();
	afx_msg void OnFileSaveToDisk();
	afx_msg void OnFileStopSaving();
	afx_msg void OnFileFromDisk();
	afx_msg void OnFileStopReadingFromDisk();
	afx_msg void OnUpdateFileStopReadingFromDisk(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFileFromDisk(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFileStopSaving(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFileSaveToDisk(CCmdUI *pCmdUI);
	afx_msg void OnFileConnectdevice();
	afx_msg void OnFileDisconnectdevice();
};


